@extends('layouts.dashboard')

@section('title', 'HR Dashboard')

@section('content')
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <!-- Total Employees -->
        <div class="relative bg-gradient-to-r from-blue-500 to-indigo-600 p-6 shadow-xl rounded-2xl text-white transform transition-all duration-300 hover:scale-105 hover:shadow-2xl">
            <div class="absolute top-4 right-4 bg-white/30 p-3 rounded-full backdrop-blur-md">
                <i class="fas fa-users text-xl text-white"></i>
            </div>
            <h2 class="text-lg font-semibold">Total Employees</h2>
            <p class="text-4xl font-extrabold animate-bounce">{{ $totalUsers }}</p>
        </div>

        <!-- Manage Department -->
        <a href="{{ route('departments.index') }}" class="block">
            <div class="relative bg-gradient-to-r from-green-500 to-teal-600 p-6 shadow-xl rounded-2xl text-white transform transition-all duration-300 hover:scale-105 hover:shadow-2xl">
                <div class="absolute top-4 right-4 bg-white/30 p-3 rounded-full backdrop-blur-md">
                    <i class="fas fa-building text-xl text-white"></i>
                </div>
                <h2 class="text-lg font-semibold">Manage Department</h2>
                <p class="text-4xl font-extrabold">{{ $totalDepartment }}</p>
            </div>
        </a>

        <!-- Manage Guest Post -->
        <a href="{{ route('guest-posts.index') }}" class="block">
            <div class="relative bg-gradient-to-r from-red-500 to-pink-600 p-6 shadow-xl rounded-2xl text-white transform transition-all duration-300 hover:scale-105 hover:shadow-2xl">
                <div class="absolute top-4 right-4 bg-white/30 p-3 rounded-full backdrop-blur-md">
                    <i class="fas fa-edit text-xl text-white"></i>
                </div>
                <h2 class="text-lg font-semibold">Manage Guest Post</h2>
                <p class="text-4xl font-extrabold">{{ $guestPost }}</p>
            </div>
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Employee Records -->
        <div class="relative bg-white p-6 shadow-lg rounded-2xl transform transition-all duration-300 hover:scale-105 hover:shadow-2xl border border-gray-200">
            <div class="absolute top-4 right-4 bg-gray-100 p-3 rounded-full">
                <i class="fas fa-folder-open text-gray-600 text-xl"></i>
            </div>
            <h2 class="text-lg font-semibold text-gray-700 flex items-center">
                📌 Employee Records
            </h2>
            <p class="text-gray-500">View and manage employee details.</p>
            <a href="{{ route('users.index') }}" class="mt-3 inline-block bg-blue-600 text-white px-5 py-2 rounded-lg hover:bg-blue-700 transition-all duration-300">
                Manage Employees
            </a>
        </div>
    </div>
@endsection
