<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{
    ProfileController, DashboardController, DepartmentController, UserController, CandidateController,
    SupportTicketController, ProjectDirectoryController, CountryController, GeoTargetController,
    GuestPostController, GigController, LinkBuildingController, TaskPhaseController,
    ProjectTaskController, ManageLinkController, PaymentAccountController,ProjectPaymentController,ProjectController
};

// Home Route
Route::get('/', function () {
    return view('welcome');
});

// Dashboard Route
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'show'])->name('dashboard');
});

// Profile Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Department Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('departments', DepartmentController::class);
});

// User Management Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('users', UserController::class)->except(['show']);
    Route::get('/users/generate-employee-code', [UserController::class, 'generateEmployeeCode'])->name('users.generateEmployeeCode');
    Route::get('/users/filter', [UserController::class, 'filterUsers'])->name('users.filter');
});

// Candidate Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('candidates', CandidateController::class)->except(['show']);
});

// Support Ticket Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('support-tickets', SupportTicketController::class);
    Route::get('/support-tickets/{id}', [SupportTicketController::class, 'show']);
});

// Project Directory Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('project-directories', ProjectDirectoryController::class);
});

// Country Management Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('countries', CountryController::class);
});

// Geo Target Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('geo-targets', GeoTargetController::class)->except(['show']);
});

// Guest Post Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('guest-posts', GuestPostController::class);
});

// Gig Management Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('gigs', GigController::class);
});

// Link Building Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('link-building', LinkBuildingController::class);
});

// Task Phase Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('task-phases', TaskPhaseController::class);
});

// Project Task Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('project-tasks', ProjectTaskController::class);
});

// Manage Links Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('manage-links', ManageLinkController::class)->except(['show']);
});

// Project Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/api/subcategories/{parent_id}', [ProjectController::class, 'getSubcategories'])->name('get.subcategories');
    Route::resource('projects', ProjectController::class);

    // Project Status Update Routes (Moved Inside Middleware)
    Route::get('/projects/{id}/status', [ProjectController::class, 'editStatus'])->name('projects.status');
    Route::put('/projects/{id}/status', [ProjectController::class, 'updateStatus'])->name('projects.status.update');
});

// Manage Links Routes
Route::middleware(['auth'])->group(function () {
    Route::resource('payment_accounts', PaymentAccountController::class);
});


Route::middleware(['auth'])->group(function () {

Route::resource('project_payments', ProjectPaymentController::class);
});



// Authentication Routes
require __DIR__.'/auth.php';
