<?php $__env->startSection('content'); ?>

<?php if(session('success')): ?>
    <div class="w-full max-w-6xl mx-auto mt-4">
        <div class="bg-green-100 border border-green-400 text-green-700 px-6 py-4 rounded relative" role="alert">
            <strong class="font-bold">Success!</strong>
            <span class="block sm:inline"><?php echo e(session('success')); ?></span>
            <span class="absolute top-0 bottom-0 right-0 px-4 py-3">
                <svg class="fill-current h-6 w-6 text-green-500" role="button" onclick="this.parentElement.parentElement.remove();" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                    <title>Close</title>
                    <path d="M14.348 5.652a1 1 0 00-1.414-1.414L10 7.172 7.066 4.238a1 1 0 10-1.414 1.414L8.828 10l-3.176 3.176a1 1 0 101.414 1.414L10 12.828l2.934 2.934a1 1 0 001.414-1.414L11.172 10l3.176-3.176z"/>
                </svg>
            </span>
        </div>
    </div>
<?php endif; ?>

<div class="w-full max-w-6xl max-h-[90vh] overflow-y-auto mx-auto bg-white p-8 shadow-lg rounded-2xl">
    <h2 class="text-2xl font-bold text-gray-800 mb-6 border-b pb-2">Update Project Status</h2>

    <form action="<?php echo e(route('projects.status.update', $project->id)); ?>" method="POST" class="space-y-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        
        <div>
            <label class="block text-gray-700 font-semibold mb-1">Project Status</label>
            <select name="project_status" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-400">
                <option value="" <?php echo e(empty($project->project_status) ? 'selected' : ''); ?>>Select Status</option>
                <option value="Complete" <?php echo e($project->project_status == 'Complete' ? 'selected' : ''); ?>>Complete</option>
                <option value="Hold" <?php echo e($project->project_status == 'Hold' ? 'selected' : ''); ?>>Hold</option>
                <option value="Paused" <?php echo e($project->project_status == 'Paused' ? 'selected' : ''); ?>>Paused</option>
                <option value="Working" <?php echo e($project->project_status == 'Working' ? 'selected' : ''); ?>>Working</option>
                <option value="Issues" <?php echo e($project->project_status == 'Issues' ? 'selected' : ''); ?>>Issues</option>
                <option value="Temp Hold" <?php echo e($project->project_status == 'Temp Hold' ? 'selected' : ''); ?>>Temp Hold</option>
            </select>
        </div>

        
        <div>
            <label class="block text-gray-700 font-semibold mb-1">Select Date</label>
            <input type="date" name="status_date" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-400" value="<?php echo e($project->status_date ?? date('Y-m-d')); ?>">
        </div>

        
        <div>
            <label class="block text-gray-700 font-semibold mb-1">Reason Description</label>
            <textarea name="reason_description" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-400" rows="4"><?php echo e($project->reason_description); ?></textarea>
        </div>

        
        <div>
            <label class="block text-gray-700 font-semibold mb-1">Can Client Rehire?</label>
            <select name="can_client_rehire" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-400">
                <option value="">Select Status</option>
                <option value="Yes" <?php echo e($project->can_client_rehire == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                <option value="No" <?php echo e($project->can_client_rehire == 'No' ? 'selected' : ''); ?>>No</option>
            </select>
        </div>

        
        <div>
            <label class="block text-gray-700 font-semibold mb-1">Rehire Date</label>
            <input type="date" name="rehire_date" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-400" value="<?php echo e($project->rehire_date); ?>">
        </div>

        
        <div class="text-right">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 transition text-white font-semibold px-6 py-3 rounded-lg shadow-sm">
                💾 Save Changes
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\crm\resources\views/projects/status.blade.php ENDPATH**/ ?>