<?php $__env->startSection('title', 'Geo Targets'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white shadow rounded-lg p-6">
        <div class="flex justify-between mb-4">
            <h2 class="text-xl font-bold">Geo Targets</h2>
            <button onclick="openModal()" class="bg-blue-500 text-white px-4 py-2 rounded">Add Geo Target</button>
        </div>
        
        <table class="w-full border-collapse border border-gray-200">
            <thead>
                <tr class="bg-gray-100">
                    <th class="border px-4 py-2">S/N</th>
                    <th class="border px-4 py-2">Title</th>
                    <th class="border px-4 py-2">Description</th>
                    <th class="border px-4 py-2">Added On / By</th>
                    <th class="border px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $geoTargets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $geoTarget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="geoTarget-<?php echo e($geoTarget->id); ?>">
                        <td class="border px-4 py-2"><?php echo e($loop->iteration); ?></td>
                        <td class="border px-4 py-2"><?php echo e($geoTarget->title); ?></td>
                        <td class="border px-4 py-2"><?php echo e($geoTarget->description); ?></td>
                        <td class="border px-4 py-2">
                            On: <?php echo e($geoTarget->created_at->format('d-m-Y')); ?><br>
                            By: <?php echo e($geoTarget->creator->name ?? 'Unknown'); ?>

                        </td>
                        <td class="border px-4 py-2">
                            <button onclick="editGeoTarget(<?php echo e($geoTarget->id); ?>)" class="bg-yellow-500 text-white px-3 py-1 rounded">Edit</button>
                            <button onclick="deleteGeoTarget(<?php echo e($geoTarget->id); ?>)" class="bg-red-500 text-white px-3 py-1 rounded">Delete</button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="mt-4">
            <?php echo e($geoTargets->links()); ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('js/geo_targets.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\crm\resources\views/geo_targets/modal.blade.php ENDPATH**/ ?>