<?php

namespace App\Http\Controllers;

use App\Models\GuestPost;
use App\Models\Country;
use Illuminate\Http\Request;

class GuestPostController extends Controller
{
    // Show the list of guest posts and the add/edit form in the same view
    public function index()
    {
        $guestPosts = GuestPost::with('country','creator')->paginate(10); // Eager load country name
       //dd($guestPosts);
        $countries = Country::all(); // Get all countries for dropdown
        
        return view('guest_posts.index', compact('guestPosts', 'countries'));
    }

    // Store a newly created guest post
    public function store(Request $request)
    {
        $validated = $request->validate([
            'website' => 'required|string|max:255',
            'da' => 'integer',
            'pa' => 'integer',
            'industry' => 'string|max:255',
            'country_id' => 'exists:countries,id',
            'traffic' => 'string|max:255',
            'publisher' => 'string|max:255',
            'publisher_price' => 'numeric',
            'our_price' => 'numeric',
            'publisher_details' => 'string',
            'live_link' => 'url',
            
        ]);
        $validated['created_by'] = auth()->id();
    
        GuestPost::create($validated);
    
        return response()->json(['success' => true, 'message' => 'Guest post added successfully!']);
    }
    
    public function edit(GuestPost $guestPost)
{
    return response()->json([
        'id' => $guestPost->id,
        'website' => $guestPost->website,
        'da' => $guestPost->da,
        'pa' => $guestPost->pa,
        'industry' => $guestPost->industry,
        'traffic' => $guestPost->traffic,
        'publisher' => $guestPost->publisher,
        'publisher_price' => $guestPost->publisher_price,
        'our_price' => $guestPost->our_price,
        'publisher_details' => $guestPost->publisher_details,
        'live_link' => $guestPost->live_link,
        'country_id' => $guestPost->country_id // Assuming country is linked via `country_id`
    ]);
}
    // Update an existing guest post

    public function update(Request $request, GuestPost $guestPost)
{
    $validated = $request->validate([
        'website' => 'required|string|max:255',
        'da' => 'nullable|integer',
        'pa' => 'nullable|integer',
        'industry' => 'nullable|string|max:255',
        'country_id' => 'nullable|exists:countries,id',
        'traffic' => 'nullable|string|max:255',
        'publisher' => 'nullable|string|max:255',
        'publisher_price' => 'nullable|numeric',
        'our_price' => 'nullable|numeric',
        'publisher_details' => 'nullable|string',
        'live_link' => 'nullable|url',
    ]);

    $guestPost->update(array_filter($validated));

    return response()->json(['success' => true, 'message' => 'Guest post updated successfully!']);
}
    

    // Delete a guest post
    public function destroy(GuestPost $guestPost)
    {
        $guestPost->delete();
    
        return response()->json(['success' => true, 'message' => 'Guest post deleted successfully.']);
    }
    
}
