<?php

namespace App\Models;
use App\Models\User;
use App\Models\Department;



use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    protected $fillable = [
        'name_or_url', 'dashboard_url', 'description', 'project_grade', 'business_type',
        'project_category_id', 'project_subcategory_id', 'country_id', 'task_phases',
        'project_manager_id', 'assign_main_employee_id', 'price', 'estimated_hours',
        'project_type', 'upwork_project_type', 'client_type', 'report_type', 'project_month',
        'sales_person_id', 'created_by', 'department_id', 'client_name', 'client_email', 'client_other_info',
        'additional_employees','project_status', 'status_date','reason_description', 'can_client_rehire', 'rehire_date'
    ];

    protected $casts = [
        'task_phases' => 'array',
        'additional_employees' => 'array',
        'project_month' => 'date',
        'status_date' => 'date',
        'rehire_date' => 'date',
    ];

    public function projectManager()
{
    return $this->belongsTo(User::class, 'project_manager_id'); // Assuming the column storing PM ID is 'project_manager_id'
}
public function salesPerson()
{
    return $this->belongsTo(User::class, 'sales_person_id');
}
public function department()
{
    return $this->belongsTo(Department::class, 'department_id');
}
public function country()
{
    return $this->belongsTo(Country::class, 'country_id');
}
public function projectCategory()
{
    return $this->belongsTo(ProjectCategory::class, 'project_category_id');
}
public function projectSubCategory()
    {
        return $this->belongsTo(ProjectCategory::class, 'project_subcategory_id');
    }
}
