@extends('layouts.dashboard')



@section('content')
<div class="bg-white shadow-md rounded-lg p-4 mb-4 flex justify-between items-center">

    <div class="flex items-center space-x-2">

        <label for="entriesPerPage" class="text-sm font-medium text-gray-700">Show</label>

        <select id="entriesPerPage" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring focus:border-blue-500 text-sm">

            <option value="10" selected>10</option>

            <option value="25">25</option>

            <option value="50">50</option>

            <option value="100">100</option>

        </select>

        <span class="text-sm font-medium text-gray-700">entries</span>
</div>
        <input type="text" id="searchInput" placeholder="Search..." 
        class="border border-gray-300 rounded-lg px-4 py-2 w-64 focus:ring focus:border-blue-500 shadow-sm">
</div>
<h2 class="text-3xl font-bold text-gray-700 mb-4">Candidate Management</h2>
<div class="bg-white p-6 shadow-md rounded-md">
<form method="GET" action="{{ route('candidates.index') }}">
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div>
            <label for="filter_department" class="block text-sm font-semibold">Department</label>
            <select id="filter_department" name="filter_department" class="w-full px-3 py-2 border rounded">
                <option value="">-- Select --</option>
                @foreach ($departments as $department)
                    <option value="{{ $department->id }}" {{ request('filter_department') == $department->id ? 'selected' : '' }}>
                        {{ $department->name }}
                    </option>
                @endforeach
            </select>
        </div>
        
        <div>
            <label for="filter_status" class="block text-sm font-semibold">Status</label>
            <select id="filter_status" name="filter_status" class="w-full px-3 py-2 border rounded">
                <option value="">-- Select --</option>
                <option value="Shortlist" {{ request('filter_status') == 'Shortlist' ? 'selected' : '' }}>Shortlist</option>
                <option value="Scheduled" {{ request('filter_status') == 'Scheduled' ? 'selected' : '' }}>Scheduled</option>
                <option value="Offered" {{ request('filter_status') == 'Offered' ? 'selected' : '' }}>Offered</option>
                <option value="Hired" {{ request('filter_status') == 'Hired' ? 'selected' : '' }}>Hired</option>
                <option value="Rejection Due to Salary Issue" {{ request('filter_status') == 'Rejection Due to Salary Issue' ? 'selected' : '' }}>Rejection Due to Salary Issue</option>
                <option value="Hold" {{ request('filter_status') == 'Hold' ? 'selected' : '' }}>Hold</option>
                <option value="Blacklisted" {{ request('filter_status') == 'Blacklisted' ? 'selected' : '' }}>Blacklisted</option>
                <option value="Technically Rejected" {{ request('filter_status') == 'Technically Rejected' ? 'selected' : '' }}>Technically Rejected</option>
            </select>
        </div>
        
        <div>
            <label for="filter_added_by" class="block text-sm font-semibold">Added By</label>
            <select id="filter_added_by" name="filter_added_by" class="w-full px-3 py-2 border rounded">
                <option value="">-- Select --</option>
                @foreach ($users as $user)
                    <option value="{{ $user->id }}" {{ request('filter_added_by') == $user->id ? 'selected' : '' }}>
                        {{ $user->name }}
                    </option>
                @endforeach
            </select>
        </div>
        
        <div class="flex items-end">
            <button id="filterButton" class="bg-blue-600 text-white px-4 py-2 rounded-md">Filter</button>
        </div>
    </div>
</form>

</div>


<div class="bg-white shadow-lg rounded-lg p-6">
    <div class="flex justify-between items-center mb-4">
        <!-- <h2 class="text-2xl font-bold text-gray-700">Candidate Management</h2> -->
        <button onclick="openModal()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg shadow-md transition-all">+ Add Candidate</button>
    </div>
    
    <div class="overflow-x-auto bg-white shadow-md rounded-lg">
        <table class="min-w-full border-collapse border border-gray-200 rounded-lg overflow-hidden" id="candidatesTable">
            <thead>
                <tr class="bg-blue-100 text-gray-700 text-left">
                    <th class="border px-6 py-3">S/No</th>
                    <th class="border px-6 py-3">Name</th>
                    <th class="border px-6 py-3">Email</th>
                    <th class="border px-6 py-3">Phone</th>
                    <th class="border px-6 py-3">Department</th>
                    <th class="border px-6 py-3">Status</th>
                    <th class="border px-6 py-3">Added By</th>
                    <th class="border px-6 py-3">Date of Joining</th>


                    <th class="border px-6 py-3">Action</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
    @if ($candidates->count() > 0)
        @foreach ($candidates as $candidate)
            <tr id="candidate-{{ $candidate->id }}" class="hover:bg-gray-50 transition-all">
                <td class="border px-6 py-4 text-center">{{ $candidates->firstItem() + $loop->index }}</td>
                <td class="border px-6 py-4 font-semibold text-gray-700">{{ $candidate->name }}</td>
                <td class="border px-6 py-4 text-gray-600">{{ $candidate->email }}</td>
                <td class="border px-6 py-4 text-gray-600">{{ $candidate->phone_number }}</td>
                <td class="border px-6 py-4 text-gray-600">{{ $candidate->department->name ?? '-' }}</td>
                <td class="border px-6 py-4 text-gray-600">{{ $candidate->status }}</td>
                <td>{{ $candidate->addedBy->name ?? 'N/A' }}</td> 
                <td>
                    {{ $candidate->date_of_joining ? \Carbon\Carbon::parse($candidate->date_of_joining)->format('d M, Y') : 'N/A' }}
                </td>
                <td class="border px-6 py-4 flex space-x-2">
                    <button onclick="editCandidate({{ $candidate->id }})" class="bg-yellow-500 hover:bg-yellow-600 text-white px-3 py-1 rounded shadow-md transition-all">Edit</button>
                    <button onclick="deleteCandidate({{ $candidate->id }})" class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded shadow-md transition-all">Delete</button>
                </td>
            </tr>
        @endforeach
    @else
        <tr>
            <td colspan="9" class="border px-6 py-4 text-center text-gray-500">No records found.</td>
        </tr>
    @endif
</tbody>

        </table>
    </div>
    <div id="paginationLinks" class="mt-4">
        {{ $candidates->links() }}
    </div>
</div>

<!-- Add/Edit Candidate Modal -->
<div id="candidateModal" class="fixed inset-0 bg-gray-900 bg-opacity-50 hidden flex items-center justify-center p-4">
    <div class="bg-white p-6 rounded-lg w-full max-w-2xl relative overflow-y-auto max-h-[90vh]">
        <button onclick="closeModal()" class="absolute top-3 right-3 text-xl text-gray-500 hover:text-black">&times;</button>
        <h2 class="text-xl font-bold mb-4 text-center" id="modalTitle">Add Candidate</h2>
        
        <form id="candidateForm" enctype="multipart/form-data" method="POST">
            @csrf
            <input type="hidden" id="candidateId" name="candidateId">

            <div class="grid grid-cols-2 gap-4">
                <div><label>Name</label><input type="text" id="name" name="name" class="w-full px-3 py-2 border rounded"></div>
                <div><label>Email</label><input type="email" id="email" name="email" class="w-full px-3 py-2 border rounded"></div>
                <div><label>Phone Number</label><input type="text" id="phone_number" name="phone_number" class="w-full px-3 py-2 border rounded"></div>
                <div><label>Experience (Years)</label><input type="text" id="experience" name="experience" class="w-full px-3 py-2 border rounded"></div>
                <div><label>Current Salary</label><input type="text" id="current_salary" name="current_salary" class="w-full px-3 py-2 border rounded"></div>
                <div><label>Expected Salary</label><input type="text" id="expected_salary" name="expected_salary" class="w-full px-3 py-2 border rounded"></div>
                <div><label>Offered Salary</label><input type="text" id="offered_salary" name="offered_salary" class="w-full px-3 py-2 border rounded"></div>
                <div><label>Date of Joining</label><input type="date" id="date_of_joining" name="date_of_joining" class="w-full px-3 py-2 border rounded"></div>
                <div><label>Department</label>
                    <select id="department_id" name="department_id" class="w-full px-3 py-2 border rounded">
                        <option value="">-- Select --</option>
                        @foreach ($departments as $department)
                            <option value="{{ $department->id }}">{{ $department->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div><label>Status</label>
                    <select id="status" name="status" class="w-full px-3 py-2 border rounded">
                        <option value="Shortlist">Shortlist</option>
                        <option value="Scheduled">Scheduled</option>
                        <option value="Offered">Offered</option>
                        <option value="Hired">Hired</option>
                        <option value="Rejection Due to Salary Issue">Rejection Due to Salary Issue</option>
                        <option value="Hold">Hold</option>
                        <option value="Blacklisted">Blacklisted</option>
                        <option value="Technically Rejected">Technically Rejected</option>
                    </select>
                </div>
                <div class="col-span-2">
    <label>Resume (PDF)</label>
    <input type="file" id="resume" name="resume" accept=".pdf" class="w-full px-3 py-2 border rounded">
    <div id="pdfPreview" class="mt-2"></div> <!-- This div will be updated dynamically -->
</div>



                <div class="col-span-2"><label>Comments</label>
                    <textarea id="comments" name="comments" class="w-full px-3 py-2 border rounded"></textarea>
                </div>
            </div>

            <div class="mt-4 flex justify-end">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Save</button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $.ajaxSetup({
    headers: {
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
    }
});

    function openModal() {
        document.getElementById('candidateModal').classList.remove('hidden');
    }

    function closeModal() {
        document.getElementById('candidateModal').classList.add('hidden');
        document.getElementById('candidateForm').reset();
        document.getElementById('candidateId').value = '';
        document.getElementById('modalTitle').innerText = 'Add Candidate';
    }

    $('#candidateForm').submit(function(event) {
    event.preventDefault();

    let candidateId = $('#candidateId').val();
    let url = candidateId ? `/candidates/${candidateId}` : "{{ route('candidates.store') }}";
    
    let formData = new FormData(this);

    if (candidateId) {
        formData.append('_method', 'PUT');
    }

    $.ajax({
        url: url,
        method: "POST",
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            $('#candidateModal').addClass('hidden');
            alert(response.message);
            location.reload();
        },
        error: function(xhr) {
            let errors = xhr.responseJSON.errors;
            if (errors) {
                $('.error-message').remove(); // Remove previous error messages
                
                // Loop through errors and display them under each input
                for (let key in errors) {
                    let errorMessage = `<span class="text-red-500 text-sm error-message">${errors[key][0]}</span>`;
                    $(`[name="${key}"]`).after(errorMessage);
                }
            } else {
                alert('Something went wrong!');
            }
        }
    });
});


function redirectToListing() {
    $('#successModal').remove(); // Remove modal
    location.reload(); // Refresh listing page
}

function editCandidate(id) {
    $.ajax({
        url: `/candidates/${id}/edit`,
        method: "GET",
        success: function(response) {
            $('#candidateId').val(response.id);
            $('#name').val(response.name);
            $('#email').val(response.email);
            $('#phone_number').val(response.phone_number);
            $('#experience').val(response.experience);
            $('#current_salary').val(response.current_salary);
            $('#expected_salary').val(response.expected_salary);
            $('#offered_salary').val(response.offered_salary);
            $('#date_of_joining').val(response.date_of_joining);
            $('#department_id').val(response.department_id);
            $('#status').val(response.status);
            $('#comments').val(response.comments);

            // Dynamically show View PDF link if resume exists
            if (response.resume) {
                let fileUrl = `/storage/${response.resume}`;
                $('#pdfPreview').html(`
                    <p>
                        <a href="${fileUrl}" target="_blank" class="text-blue-500 underline">
                            View Full PDF
                        </a>
                    </p>
                `);
            } else {
                $('#pdfPreview').html('');
            }

            // Open the modal
            openModal();
        },
        error: function(xhr) {
            console.error("Error fetching candidate data:", xhr.responseText);
            alert("Error fetching candidate data");
        }
    });
}


</script>
<script>
function deleteCandidate(id) {
    if (!confirm('Are you sure you want to delete this candidate?')) return;

    fetch(`/candidates/${id}`, {
        method: 'DELETE', // Corrected 'type' to 'method'
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json'
        }
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then(data => {
        alert(data.success);
        location.reload(); // Refresh page after delete
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to delete candidate.');
    });
}


</script>
<script>
    window.addEventListener("load", function () {
        if (performance.navigation.type === 1) { // Checks if the page is refreshed
            window.location.href = "{{ route('candidates.index') }}"; // Redirect to the main page without filters
        }
    });
    document.addEventListener("DOMContentLoaded", function () {
    let searchInput = document.getElementById("searchInput");
    let entriesSelect = document.getElementById("entriesPerPage");
    let table = document.querySelector("table tbody");
    let rows = table.getElementsByTagName("tr");

    // Function to filter table rows based on search input
    function filterTable() {
        let searchText = searchInput.value.toLowerCase();

        Array.from(rows).forEach(row => {
            let textContent = row.innerText.toLowerCase();
            row.style.display = textContent.includes(searchText) ? "" : "none";
        });
    }

    // Function to control entries per page
    function updateEntriesPerPage() {
        let numEntries = parseInt(entriesSelect.value);
        let totalRows = rows.length;

        // Show only selected number of rows
        Array.from(rows).forEach((row, index) => {
            row.style.display = index < numEntries ? "" : "none";
        });
    }

    // Event listeners
    searchInput.addEventListener("keyup", filterTable);
    entriesSelect.addEventListener("change", updateEntriesPerPage);

    // Initialize the table with the default entries per page
    updateEntriesPerPage();
});

</script>

@endsection
