<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Dashboard')</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@2.8.2/dist/alpine.js" defer></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>



    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#4F46E5',
                        secondary: '#3B82F6',
                        dark: '#1E293B'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-100 flex">

    <!-- Include Sidebar -->
    @include('layouts.partials.sidebar')

    <!-- Main Content -->
    <div class="flex-1 flex flex-col">
        
        <!-- Include Header -->
        @include('layouts.partials.header')

        <!-- Page Content -->
        <main class="p-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-1 gap-6">
            @yield('content')
        </main>

        <!-- Include Footer -->
        @include('layouts.partials.footer')

    </div>
 <!-- Yield scripts here -->
 @yield('scripts')

</body>
</html>
