@foreach ($users as $user)
<tr id="user-{{ $user->id }}" class="hover:bg-gray-50 transition-all">
<td class="border px-6 py-4 text-center">
    @if ($users instanceof \Illuminate\Pagination\LengthAwarePaginator)
        {{ $users->firstItem() + $loop->index }}
    @else
        {{ $loop->iteration }}
    @endif
</td>    <td class="border px-6 py-4 flex items-center space-x-3">
        <img src="{{ $user->image ? asset('storage/' . $user->image) : asset('storage/images/default.png') }}" alt="User Image" class="w-12 h-12 rounded-full object-cover shadow-md">
        <span class="font-semibold text-gray-700">{{ $user->name }}</span>
    </td>
    <td class="border px-6 py-4 text-gray-600">
        <span class="block"><strong>Email:</strong> {{ $user->email }}</span>
        <span class="block"><strong>Phone:</strong> {{ $user->phone_number }}</span>
        <span class="block"><strong>Disable Login:</strong> {{ $user->disable_login ? 'Yes' : 'No' }}</span>
    </td>
    <td class="border px-6 py-4">
        <span class="block font-semibold text-blue-700">{{ $user->roles->pluck('name')->first() }}</span>
        <span class="block text-gray-600">Dept: {{ $user->department->name ?? '-' }}</span>
        <span class="block text-gray-600">Emp Code: {{ $user->employee_code }}</span>
        <span class="block text-gray-600">Reporting: {{ $user->reportingPerson?->name ?? '-' }}</span><br>
        </td>
    <td class="border px-6 py-4 text-gray-600">
        <strong>Monthly:</strong> {{ $user->monthly_target }}<br>
        <strong>Incentive:</strong> {{ $user->upsell_incentive }}%
    </td>
    <td class="border px-6 py-4 flex space-x-2">
        <button onclick="editUser({{ $user->id }})" class="bg-yellow-500 hover:bg-yellow-600 text-white px-3 py-1 rounded shadow-md transition-all">Edit</button>
        <button onclick="deleteUser({{ $user->id }})" class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded shadow-md transition-all">Delete</button>
    </td>
</tr>
@endforeach

@if ($users instanceof \Illuminate\Pagination\LengthAwarePaginator && $users->total() > 6)
    <div id="paginationLinks" class="mt-4">
        {{ $users->links() }}
    </div>
@else
    <div id="paginationLinks" style="display: none;"></div>
@endif
