<?php $__env->startSection('title', 'Bank Accounts'); ?>

<?php $__env->startSection('content'); ?>
<div id="successMessage" class="hidden bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
    <strong>Success!</strong> <span id="successText"></span>
</div>
<div class="bg-white shadow-md rounded-lg p-6 mb-6 flex justify-between items-center">
    <div class="flex items-center space-x-3">
        <label for="entriesPerPage" class="text-sm font-medium text-gray-600">Show</label>
        <select id="entriesPerPage" class="border border-gray-300 rounded-md px-3 py-1.5 focus:ring focus:border-blue-500 text-sm">
            <option value="10" selected>10</option>
            <option value="25">25</option>
            <option value="50">50</option>
            <option value="100">100</option>
        </select>
        <span class="text-sm font-medium text-gray-600">entries</span>
    </div>
    <input type="text" id="searchInput" placeholder="Search bank accounts..." 
        class="border border-gray-300 rounded-md px-4 py-2 w-72 focus:ring focus:border-blue-500 shadow-md text-gray-700 transition">
</div>

<div class="bg-white shadow-md rounded-lg p-6">
    <div class="flex justify-between items-center mb-5">
        <h2 class="text-2xl font-semibold text-gray-800">Bank Accounts</h2>
        <button onclick="openModal()" class="bg-blue-600 text-white px-5 py-2 rounded-md shadow hover:bg-blue-700 transition duration-200">
            + Add Bank Account
        </button>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full border-collapse bg-white shadow-md rounded-lg text-left" id="bankAccountsTable">
            <thead class="bg-gray-200 text-gray-700 font-semibold">
                <tr>
                    <th class="border px-5 py-3">S/N</th>
                    <th class="border px-5 py-3">Bank Name</th>
                    <th class="border px-5 py-3">Account Number</th>
                    <th class="border px-5 py-3">IFSC Code</th>

                    <th class="border px-5 py-3 text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $bankAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="account-<?php echo e($account->id); ?>" class="hover:bg-gray-100 transition">
                        <td class="border px-5 py-3 text-gray-700"><?php echo e($bankAccounts->firstItem() + $loop->index); ?></td>
                        <td class="border px-5 py-3 font-medium text-gray-900"><?php echo e($account->bank_name); ?></td>
                        <td class="border px-5 py-3 font-medium text-gray-900"><?php echo e($account->ifsc_code); ?></td>

                        <td class="border px-5 py-3 text-gray-700"><?php echo e($account->account_number); ?></td>
                        <td class="border px-5 py-3 flex justify-center space-x-2">
                            <button onclick="editAccount(<?php echo e($account->id); ?>)" 
                                class="bg-yellow-500 text-white px-3 py-1.5 rounded-md shadow hover:bg-yellow-600 transition">
                                Edit
                            </button>
                            <button onclick="deleteAccount(<?php echo e($account->id); ?>)"
                                class="bg-red-500 text-white px-3 py-1.5 rounded-md shadow hover:bg-red-600 transition">
                                Delete
                            </button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="mt-6 flex justify-end">
        <?php echo e($bankAccounts->links()); ?>

    </div>
</div>

<!-- Add/Edit Bank Account Modal -->
<!-- Add/Edit Bank Account Modal -->
<div id="bankAccountModal" class="fixed inset-0 bg-gray-900 bg-opacity-50 flex items-center justify-center hidden overflow-y-auto">
    <div class="bg-white rounded-lg shadow-lg p-6 w-full max-w-md max-h-[90vh] overflow-y-auto">
        <h2 id="modalTitle" class="text-xl font-semibold mb-4">Add Bank Account</h2>
        <form id="bankAccountForm" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" id="account_id" name="account_id">
            
            <div class="mb-4">
                <label for="account_name" class="block text-sm font-medium text-gray-700">Account Name</label>
                <input type="text" id="account_name" name="account_name"  
                    class="w-full border border-gray-300 rounded-md px-3 py-2 focus:ring focus:border-blue-500">
            </div>

            <div class="mb-4">
                <label for="bank_name" class="block text-sm font-medium text-gray-700">Bank Name</label>
                <input type="text" id="bank_name" name="bank_name"  
                    class="w-full border border-gray-300 rounded-md px-3 py-2 focus:ring focus:border-blue-500">
            </div>

            <div class="mb-4">
                <label for="ifsc_code" class="block text-sm font-medium text-gray-700">IFSC Code</label>
                <input type="text" id="ifsc_code" name="ifsc_code"  
                    class="w-full border border-gray-300 rounded-md px-3 py-2 focus:ring focus:border-blue-500">
            </div>

            <div class="mb-4">
                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                <textarea id="description" name="description" rows="4" 
                    class="w-full border border-gray-300 rounded-md px-3 py-2 focus:ring focus:border-blue-500"></textarea>
            </div>

            <div class="mb-4">
                <label for="account_number" class="block text-sm font-medium text-gray-700">Account Number</label>
                <input type="text" id="account_number" name="account_number" required 
                    class="w-full border border-gray-300 rounded-md px-3 py-2 focus:ring focus:border-blue-500">
            </div>

           
            <div class="mb-4">
                <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                <select id="status" name="status" required 
                    class="w-full border border-gray-300 rounded-md px-3 py-2 focus:ring focus:border-blue-500">
                    <option value="Active">Active</option>
                    <option value="Inactive">Inactive</option>
                </select>
            </div>

            <div class="flex justify-end space-x-3">
                <button type="button" onclick="closeModal()" class="bg-gray-400 text-white px-4 py-2 rounded-md">Cancel</button>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md">Save</button>
            </div>
        </form>
    </div>
</div>
<div>
</div>


<script>
    function openModal(account = null) {
        document.getElementById('bankAccountForm').reset();
        document.getElementById('account_id').value = account ? account.id : '';
        document.getElementById('modalTitle').innerText = account ? 'Edit Bank Account' : 'Add Bank Account';

        if (account) {
            document.getElementById('bank_name').value = account.bank_name;
            document.getElementById('account_name').value = account.account_name;

            document.getElementById('account_number').value = account.account_number;
            document.getElementById('ifsc_code').value = account.ifsc_code;
            document.getElementById('description').value = account.description;



        }

        document.getElementById('bankAccountModal').classList.remove('hidden');
    }

    function closeModal() {
        document.getElementById('bankAccountModal').classList.add('hidden');
    }

    function editAccount(accountId) {
        fetch(`/payment_accounts/${accountId}/edit`)
            .then(response => response.json())
            .then(data => {
                openModal(data);
            })
            .catch(error => console.error('Error:', error));
    }

document.getElementById('bankAccountForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    let formData = new FormData(this);
    let accountId = document.getElementById('account_id').value;
    let url = accountId ? `/payment_accounts/${accountId}` : '/payment_accounts';
    
    if (accountId) {
        formData.append('_method', 'PUT'); // Laravel method spoofing
    }
    
    fetch(url, {
        method: 'POST', // Use POST instead of PUT
        headers: { 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content') },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('successText').innerText = data.message;
            document.getElementById('successMessage').classList.remove('hidden');
            
            setTimeout(() => {
                document.getElementById('successMessage').classList.add('hidden');
                closeModal();
                location.reload(); // Refresh page to update table
            }, 2000);
        }
    })
    .catch(error => console.error('Error:', error));
});


</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\crm\resources\views/payment_accounts/index.blade.php ENDPATH**/ ?>