<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Department;
use App\Models\GuestPost;



class DashboardController extends Controller
{
    public function show()
    {
        $user = Auth::user();
        $role = $user->roles->first()->name; // Assuming a user has only one role
        //dd($role);
        $totalUsers = User::count();
        $totalDepartment = Department::count();
        $guestPost = GuestPost::count();
       // dd($guestPost);


    
        return view('dashboard.hr', compact('role','totalUsers','totalDepartment','guestPost')); // Pass role to the view
    }
}
