<?php

namespace App\Http\Controllers;

use App\Models\Gig;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GigController extends Controller
{
    public function index()
    {
        $gigs = Gig::with('user')->latest()->paginate(10);
        return view('gigs.index', compact('gigs'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'website' => 'required|string|max:255',
            'price' => 'required|numeric',
            'gig_link' => 'required|url',
            'gig_on' => 'required|in:Fiverr,PPH,Upwork,Other',
        ]);

        $validated['created_by'] = Auth::id();

        Gig::create($validated);

        return response()->json(['success' => true, 'message' => 'Gig added successfully!']);
    }
    public function edit(Gig $gig)
{
    return response()->json([
        'id' => $gig->id,
        'website' => $gig->website,
        'price' => $gig->price,
        'gig_link' => $gig->gig_link,
        'gig_on' => $gig->gig_on,
        'created_by' => $gig->created_by,
    ]);
}

    
    public function update(Request $request, Gig $gig)
    {
        $validated = $request->validate([
            'website' => 'required|string|max:255',
            'price' => 'required|numeric',
            'gig_link' => 'required|url',
            'gig_on' => 'required|in:Fiverr,PPH,Upwork,Other',
        ]);

        $gig->update($validated);

        return response()->json(['success' => true, 'message' => 'Gig updated successfully!']);
    }

    public function destroy(Gig $gig)
    {
        $gig->delete();
        return response()->json(['success' => true, 'message' => 'Gig deleted successfully!']);
    }
}
