<?php

namespace App\Http\Controllers;

use App\Models\PaymentAccount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PaymentAccountController extends Controller
{
    public function index()
    {
        $bankAccounts = PaymentAccount::latest()->paginate(10);
      //  dd($bankAccounts);

        return view('payment_accounts.index', compact('bankAccounts'));
    }

    public function create()
    {
        return view('payment_accounts.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'bank_name' => 'required|string|max:255',
            'account_name' => 'required|string|max:255',
            'ifsc_code' => 'required|string|max:50',
            'description' => 'nullable|string',
            'account_number' => 'required|max:50',
            'status' => 'required|in:Active,Inactive',
        ]);
    
        $validated['created_by'] = auth()->id(); 
        $bankAccount = PaymentAccount::create($validated);
    
        return response()->json([
            'success' => true,
            'message' => 'Bank account added successfully!',
            'data' => $bankAccount
        ]);
    }
    
    
    public function edit($id)
    {
        $account = PaymentAccount::findOrFail($id);
        return response()->json($account); // Return JSON data instead of a view
    }
    public function update(Request $request, PaymentAccount $paymentAccount)
    {
        $request->validate([

            'bank_name' => 'string|max:255',
            'account_name' => 'string|max:255',
            'ifsc_code' => 'string|max:50',
            'description' => 'nullable|string',
            'account_number' => 'required|max:50',
            'status' => 'in:Active,Inactive',
        ]);

        $paymentAccount->update($request->all());

        return redirect()->route('payment_accounts.index')->with('success', 'Payment Account updated successfully.');
    }

    public function destroy(PaymentAccount $paymentAccount)
    {
        $paymentAccount->delete();
        return redirect()->route('payment_accounts.index')->with('success', 'Payment Account deleted successfully.');
    }
}
