<?php $__env->startSection('content'); ?>
<style>
    /* Sticky header */
    .table-container {
        max-height: 600px; /* Adjust height based on preference */
        overflow-y: auto;
    }
    thead tr th {
        position: sticky;
        top: 0;
        background: #f8f8f8;
        z-index: 10;
    }
    /* Alternating row colors */
    tbody tr:nth-child(even) {
        background-color: #f9f9f9;
    }
    /* Tooltip */
    .tooltip {
        position: relative;
        display: inline-block;
        cursor: pointer;
    }
    .tooltip .tooltiptext {
        visibility: hidden;
        width: 200px;
        background-color: black;
        color: #fff;
        text-align: center;
        border-radius: 6px;
        padding: 5px;
        position: absolute;
        z-index: 1;
        bottom: 100%;
        left: 50%;
        margin-left: -100px;
        opacity: 0;
        transition: opacity 0.3s;
    }
    .tooltip:hover .tooltiptext {
        visibility: visible;
        opacity: 1;
    }
</style>

<div class="container mx-auto p-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-2xl font-bold">Project Management</h2>
        <button onclick="openModal('projectFormModal')" class="bg-blue-600 text-white px-4 py-2 rounded">+ Add Project</button>
    </div>

    <!-- Filters Section -->
    <div class="bg-white p-4 shadow-md rounded-lg mb-4">
        <button onclick="toggleFilters()" class="text-blue-600 font-semibold">Filters ▼</button>
        <div id="filtersSection" class="hidden mt-4">
            <div class="grid grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-semibold">Project Grade</label>
                    <select id="filter_grade" class="w-full px-3 py-2 border rounded">
                        <option value="">Select</option>
                        <option value="A">A</option>
                        <option value="AA">AA</option>
                        <option value="AAA">AAA</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-semibold">Project Manager</label>
                    <select id="filter_manager" class="w-full px-3 py-2 border rounded">
                        <option value="">-- Select --</option>
                        <?php $__currentLoopData = $projectManagers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manager): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($manager->id); ?>"><?php echo e($manager->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="pt-6">
                    <button class="bg-blue-600 text-white px-4 py-2 rounded">Apply</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Project Listing Table -->
   <!-- Project Listing Table -->
<div class="bg-white shadow-md rounded-lg overflow-hidden">
    <div class="overflow-x-auto max-h-[500px]"> <!-- Added scrollable container -->
        <table class="w-full border-collapse border border-gray-300">
            <thead class="sticky top-0 bg-gray-200">
                <tr>
                    <th class="border border-gray-300 px-4 py-2">#</th>
                    <th class="border border-gray-300 px-4 py-2">Name/URL</th>
                    <th class="border border-gray-300 px-4 py-2">Office Details</th>
                    <th class="border border-gray-300 px-4 py-2">Price/Hours</th>
                    <th class="border border-gray-300 px-4 py-2">Added On</th>
                    <th class="border border-gray-300 px-4 py-2">Type</th>
                    <th class="border border-gray-300 px-4 py-2">Hired From</th>
                    <th class="border border-gray-300 px-4 py-2">Project Status</th>
                    <th class="border border-gray-300 px-4 py-2">Client Details</th>

                    <th class="border border-gray-300 px-4 py-2">Action</th>
                    <th class="border border-gray-300 px-4 py-2">Description</th>


                </tr>
            </thead>
            <tbody>
    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr class="<?php echo e($project->project_status == 'Complete' ? 'bg-green-200' : ''); ?>"> <!-- Apply green background if Complete -->
        <td class="border border-gray-300 px-4 py-2"><?php echo e($key + 1); ?></td>
        <td class="border border-gray-300 px-4 py-2">
            <strong><?php echo e($project->name_or_url); ?></strong><br>
            <a href="<?php echo e($project->dashboard_url); ?>" target="_blank" class="text-blue-500">Dashboard Link</a>
        </td>
        <td class="border border-gray-300 px-4 py-2">
            <strong>Business:</strong> <?php echo e($project->business_type); ?><br>
            <strong>Grade:</strong> <?php echo e($project->project_grade); ?><br>
            <strong>PM:</strong> <?php echo e(optional($project->projectManager)->name ?? '-'); ?><br>
            <strong>Sales:</strong> <?php echo e(optional($project->salesPerson)->name ?? '-'); ?><br>
            <strong>Department:</strong> <?php echo e(optional($project->department)->name ?? '-'); ?>

        </td>
        <td class="border border-gray-300 px-4 py-2">
            <strong>Price:</strong> $<?php echo e($project->price ?? '0'); ?><br>
            <strong>Hours:</strong> <?php echo e($project->estimated_hours ?? 'N/A'); ?>

        </td>
        <td class="border border-gray-300 px-4 py-2"><?php echo e($project->created_at->format('d-M-Y')); ?></td>
        <td class="border border-gray-300 px-4 py-2">
            <strong>Project:</strong> <?php echo e($project->project_type); ?><br>
            <strong>Report:</strong> <?php echo e($project->report_type); ?><br>
            <strong>Client Type:</strong> <?php echo e($project->client_type); ?>

        </td>
        <td class="border border-gray-300 px-4 py-2">
            <strong>Category:</strong> <?php echo e(optional($project->projectCategory)->name ?? '-'); ?><br>
            <strong>Sub Category:</strong> <?php echo e(optional($project->projectSubCategory)->name ?? '-'); ?><br>
            <strong>Country:</strong> <?php echo e(optional($project->country)->name ?? '-'); ?>

            <strong>Project Type:</strong> <?php echo e($project->project_type ?? '-'); ?><br>
            <strong>Report Type:</strong> <?php echo e($project->report_type ?? '-'); ?>

        </td>
        <td class="border border-gray-300 px-4 py-2">
            <span class="<?php echo e($project->project_status == 'Working' ? 'text-green-500 font-bold' : ''); ?>">
                <?php echo e($project->project_status ?? 'Working'); ?>

            </span>
            


        </td>
        <td class="border border-gray-300 px-4 py-2">
            <strong>Name:</strong> <?php echo e($project->client_name); ?><br>
            <strong>Email:</strong> <?php echo e($project->client_email); ?><br>
            <strong>Other Info:</strong> 
            <span class="tooltip">
                <?php echo e(Str::limit($project->client_other_info, 20)); ?>

                <span class="tooltiptext"><?php echo e($project->client_other_info); ?></span>
            </span>
        </td>
        <td class="border border-gray-300 px-4 py-2">
            <a href="<?php echo e(route('projects.status', $project->id)); ?>" class="<?php echo e($project->project_status == 'Working' ? 'bg-green-500' : 'bg-blue-500'); ?> text-white px-3 py-1 rounded">
                Update Status
            </a><br><br>
            <a href="<?php echo e(route('project_payments.index', ['project_id' => $project->id])); ?>" 
   class="bg-indigo-600 text-white px-3 py-1.5 rounded-md hover:bg-indigo-700 transition">
   Payment
</a>
            
        </td>
        <td class="border border-gray-300 px-4 py-2">
            <span class="tooltip">
                <?php echo e(Str::limit($project->description, 100)); ?>

                <span class="tooltiptext"><?php echo e($project->description); ?></span>
            </span>
        </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
        </table>
    </div>



    </div>

    <!-- Pagination -->
    <div class="mt-4">
        <?php echo e($projects->links()); ?>

    </div>
</div>

<!-- Add/Edit Project Modal -->
<div id="projectFormModal" class="hidden fixed inset-0 bg-gray-900 bg-opacity-50 flex items-center justify-center">
    <div class="bg-white p-6 rounded-lg w-full max-w-5xl max-h-[90vh] overflow-y-auto relative">
        <button onclick="closeModal('projectFormModal')" class="absolute top-3 right-3 text-xl text-gray-500 hover:text-black">&times;</button>
        <h2 class="text-xl font-bold mb-4 text-center">Add Project</h2>

        <form id="projectForm" method="POST" action="<?php echo e(route('projects.store')); ?>">
        <div class="grid grid-cols-2 gap-4">
                <!-- Project Name/URL -->
                <div>
                    <label class="block text-sm font-semibold">Project Name/URL</label>
                    <input type="text" name="name_or_url" class="w-full px-3 py-2 border rounded">
                </div>

                <!-- Dashboard URL -->
                <div>
                    <label class="block text-sm font-semibold">Dashboard URL</label>
                    <input type="url" name="dashboard_url" class="w-full px-3 py-2 border rounded">
                </div>

                <!-- Description -->
                <div class="col-span-2">
                    <label class="block text-sm font-semibold">Description</label>
                    <textarea name="description" class="w-full px-3 py-2 border rounded"></textarea>
                </div>

                <!-- Project Grade -->
                <div>
                    <label class="block text-sm font-semibold">Project Grade</label>
                    <select name="project_grade" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Project Grade</option>

                        <option value="A">A</option>
                        <option value="AA">AA</option>
                        <option value="AAA">AAA</option>
                    </select>
                </div>

                <!-- Business Type -->
                <div>
                    <label class="block text-sm font-semibold">Business Type</label>
                    <select name="business_type" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Business Type</option>

                        <option value="Startup">Startup</option>
                        <option value="Small">Small</option>
                        <option value="Mid-level">Mid-level</option>
                        <option value="Enterprise">Enterprise</option>
                    </select>
                </div>

                <div>
    <label class="block text-sm font-semibold">Main Category</label>
    <select id="main_category" name="project_category_id" class="w-full px-3 py-2 border rounded">
        <option value="">Select Main Category</option>
        <?php $__currentLoopData = $mainCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mainCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($mainCategory->id); ?>"><?php echo e($mainCategory->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<!-- Sub Category -->
<div>
    <label class="block text-sm font-semibold">Sub Category</label>
    <select id="sub_category" name="project_subcategory_id" class="w-full px-3 py-2 border rounded" disabled>
        <option value="">Select Subcategory</option>
    </select>
</div>

                <!-- Country -->
                <div>
                    <label class="block text-sm font-semibold">Country</label>
                    <select name="country_id" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Country</option>

                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Task Phases -->
                <div>
    <label class="block text-sm font-semibold">Task Phase</label>
    <div class="border p-2 rounded max-h-40 overflow-y-auto">
        <?php $__currentLoopData = $taskPhases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taskPhase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <label class="block">
                <input type="checkbox" name="task_phases[]" value="<?php echo e($taskPhase->id); ?>"> 
                <?php echo e($taskPhase->title); ?>

            </label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

                <!-- Project Manager -->
                <div>
                    <label class="block text-sm font-semibold">Project Manager</label>
                    <select name="project_manager_id" class="w-full px-3 py-2 border rounded">
                        <?php $__currentLoopData = $projectManagers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manager): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($manager->id); ?>"><?php echo e($manager->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Assign Main Employee -->
                <div>
                    <label class="block text-sm font-semibold">Assign Main Employee</label>
                    <select name="assign_main_employee_id" class="w-full px-3 py-2 border rounded">
                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Price (USD) -->
                <div>
                    <label class="block text-sm font-semibold">Price (USD)</label>
                    <input type="number" name="price" class="w-full px-3 py-2 border rounded">
                </div>

                <!-- Estimated Hours -->
                <div>
                    <label class="block text-sm font-semibold">Estimated Hours</label>
                    <input type="number" name="estimated_hours" class="w-full px-3 py-2 border rounded">
                </div>

                <!-- Project Type -->
                <div>
                    <label class="block text-sm font-semibold">Project Type</label>
                    <select name="project_type" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Project Type</option>

                        <option value="Ongoing">Ongoing</option>
                        <option value="One-time">One-time</option>
                    </select>
                </div>

                <!-- Upwork Project Type -->
                <div>
                    <label class="block text-sm font-semibold">Upwork Project Type</label>
                    <select name="upwork_project_type" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Project Type</option>

                        <option value="Hourly">Hourly</option>
                        <option value="Fixed">Fixed</option>
                    </select>
                </div>

                <!-- Client Type -->
                <div>
                    <label class="block text-sm font-semibold">Client Type</label>
                    <select name="client_type" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Client Type</option>

                        <option value="New Client">New Client</option>
                        <option value="Old Client">Old Client</option>
                    </select>
                </div>

                <!-- Report Type -->
                <div>
                    <label class="block text-sm font-semibold">Report Type</label>
                    <select name="report_type" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Report Type</option>

                        <option value="Weekly">Weekly</option>
                        <option value="Bi-Weekly">Bi-Weekly</option>
                        <option value="Monthly">Monthly</option>
                    </select>
                </div>

                <!-- Project Month -->
                <div>
                    <label class="block text-sm font-semibold">Project Month</label>
                    <input type="date" name="project_month" class="w-full px-3 py-2 border rounded">
                </div>

                <!-- Sales Person -->
                <div>
                    <label class="block text-sm font-semibold">Sales Person</label>
                    <select name="sales_person_id" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Sales Person</option>
                        <?php $__currentLoopData = $salesPersons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sales): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($sales->id); ?>"><?php echo e($sales->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <!-- Department -->

                <div>
                    <label class="block text-sm font-semibold">Department</label>
                    <select name="department_id" class="w-full px-3 py-2 border rounded">
                    <option value="">Select Sales Person</option>
                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($department->id); ?>"><?php echo e($department->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Client Name -->
                <div>
                    <label class="block text-sm font-semibold">Client Name</label>
                    <input type="text" name="client_name" class="w-full px-3 py-2 border rounded">
                </div>

                <!-- Client Email -->
                <div>
                    <label class="block text-sm font-semibold">Client Email</label>
                    <input type="email" name="client_email" class="w-full px-3 py-2 border rounded">
                </div>

                <!-- Client Other Info -->
                <div class="col-span-2">
                    <label class="block text-sm font-semibold">Client Other Info</label>
                    <textarea name="client_other_info" class="w-full px-3 py-2 border rounded"></textarea>
                </div>
<!-- Add More Employees -->
              <div class="col-span-2">
               <label class="block text-sm font-semibold">Add More Employees</label>
               <div class="border p-2 rounded max-h-40 overflow-y-auto">
              <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
             <label class="block">
                <input type="checkbox" name="additional_employees[]" value="<?php echo e($employee->id); ?>"> 
                <?php echo e($employee->name); ?>

            </label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     </div>
</div>



            </div>
            <!-- Save Button -->
<div class="mt-4 text-center">
    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">
        Save
    </button>
</div>

        </form>
    </div>
</div>

    

<script>
function openModal(id) {
    document.getElementById(id).classList.remove('hidden');
}

function closeModal(id) {
    document.getElementById(id).classList.add('hidden');
}

function viewProjectDetails(id) {
    alert('View project details: ' + id);
}

function editProject(id) {
    alert('Edit project: ' + id);
}

function deleteProject(id) {
    if (confirm('Are you sure you want to delete this project?')) {
        // Delete logic here
    }
}


$(document).ready(function () {
    $('#projectForm').on('submit', function (event) {
        event.preventDefault(); // Prevent the default form submission
        
        let formData = new FormData(this); // Get form data
        let url = "<?php echo e(route('projects.store')); ?>"; // Laravel route
        let token = "<?php echo e(csrf_token()); ?>"; // CSRF token for security

        $.ajax({
            url: url,
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            headers: {
                'X-CSRF-TOKEN': token
            },
            beforeSend: function () {
                $('button[type="submit"]').prop('disabled', true).text('Saving...');
                $('.error-text').remove(); // Remove previous error messages
            },
            success: function (response) {
                if (response.success) {
                    alert(response.message); // Success message
                    closeModal('projectFormModal'); // Close the modal
                    $('#projectForm')[0].reset(); // Reset form
                    location.reload(); // Refresh the listing page (optional)
                }
            },
            error: function (xhr) {
                $('button[type="submit"]').prop('disabled', false).text('Save');
                let errors = xhr.responseJSON.errors;
                if (errors) {
                    $.each(errors, function (key, value) {
                        let inputField = $('[name="' + key + '"]');
                        inputField.after('<span class="error-text text-red-500 text-sm">' + value[0] + '</span>');
                    });
                }
            }
        });
    });
});





$(document).ready(function () {
    $('#main_category').on('change', function () {
        var mainCategoryId = $(this).val();

        if (mainCategoryId) {
            $.ajax({
                url: "<?php echo e(url('/api/subcategories')); ?>/" + mainCategoryId, // Pass mainCategoryId in URL
                type: "GET",
                success: function (response) {
                    $('#sub_category').empty().append('<option value="">Select Subcategory</option>');
                    if (response.length > 0) {
                        $.each(response, function (key, subcategory) {
                            $('#sub_category').append('<option value="' + subcategory.id + '">' + subcategory.name + '</option>');
                        });
                        $('#sub_category').prop('disabled', false);
                    } else {
                        $('#sub_category').prop('disabled', true);
                    }
                }
            });
        } else {
            $('#sub_category').empty().append('<option value="">Select Subcategory</option>').prop('disabled', true);
        }
    });
});

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\crm\resources\views/projects/index.blade.php ENDPATH**/ ?>