<aside class="w-64 bg-gray-900 text-white h-screen p-4 flex flex-col shadow-xl transition-all duration-300">
    <!-- Logo / Title -->
    <h2 class="text-2xl font-bold mb-6 text-center text-blue-400 animate-pulse">SEO DISCOVERY</h2>

    <nav class="flex-1 space-y-1">
        <!-- Dashboard -->
        <a href="<?php echo e(route('dashboard')); ?>"
            class="flex items-center py-3 px-4 rounded-lg transition-all duration-300 hover:bg-gradient-to-r from-blue-500 to-purple-500 hover:shadow-lg">
            📊 <span class="ml-3">Dashboard</span>
        </a>

        <!-- Profile -->
        <a href="<?php echo e(route('profile.edit')); ?>"
            class="flex items-center py-3 px-4 rounded-lg transition-all duration-300 hover:bg-gradient-to-r from-blue-500 to-purple-500 hover:shadow-lg">
            🧑 <span class="ml-3">Profile</span>
        </a>

        <!-- HR Dropdown -->
        <?php if(in_array(Auth::user()->roles->first()->name, ['HR','Admin'])): ?>
        <div x-data="{ open: false }" class="relative">
            <button @click="open = !open"
                class="flex items-center w-full py-3 px-4 rounded-lg transition-all duration-300 hover:bg-gradient-to-r from-blue-500 to-purple-500 hover:shadow-lg">
                👥 <span class="ml-3 flex-1">HR</span>
                <span class="transform transition-transform duration-300" :class="open ? 'rotate-180' : ''">▼</span>
            </button>
            <!-- Dropdown Content -->
            <div x-show="open" @click.away="open = false"
                x-transition:enter="transition ease-out duration-300 transform opacity-0 scale-95"
                x-transition:enter-end="opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-200 transform opacity-100 scale-100"
                x-transition:leave-end="opacity-0 scale-95"
                class="mt-2 bg-gray-800 rounded-lg shadow-lg overflow-hidden">
                <a href="<?php echo e(route('departments.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">📋 Department Management</a>
                <a href="<?php echo e(route('users.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">👥 User Management</a>
                <a href="<?php echo e(route('candidates.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">📝 Candidates Management</a>
            </div>
        </div>
        <?php endif; ?>

        <!-- Production Dropdown -->
        <?php if(in_array(Auth::user()->roles->first()->name, ['HR','Admin','Project Manager'])): ?>
        <div x-data="{ open: false }" class="relative">
            <button @click="open = !open"
                class="flex items-center w-full py-3 px-4 rounded-lg transition-all duration-300 hover:bg-gradient-to-r from-blue-500 to-purple-500 hover:shadow-lg">
                🏗 <span class="ml-3 flex-1">Production</span>
                <span class="transform transition-transform duration-300" :class="open ? 'rotate-180' : ''">▼</span>
            </button>
            <div x-show="open" @click.away="open = false"
                x-transition:enter="transition ease-out duration-300 transform opacity-0 scale-95"
                x-transition:enter-end="opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-200 transform opacity-100 scale-100"
                x-transition:leave-end="opacity-0 scale-95"
                class="mt-2 bg-gray-800 rounded-lg shadow-lg overflow-hidden">
                <a href="<?php echo e(route('projects.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">📝 Project Management</a>
                <a href="<?php echo e(route('project-tasks.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">📝 Project Task</a>
              
                <a href="<?php echo e(route('task-phases.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">📊 Task Phase</a>
                <a href="<?php echo e(route('project-directories.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">📂 Project Categories</a>
                <a href="<?php echo e(route('countries.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">🌍 All Countries</a>
            </div>
        </div>
        <?php endif; ?>

        <!-- Guest Post Department -->
        <div x-data="{ open: false }" class="relative">
            <button @click="open = !open"
                class="flex items-center w-full py-3 px-4 rounded-lg transition-all duration-300 hover:bg-gradient-to-r from-blue-500 to-purple-500 hover:shadow-lg">
                📢 <span class="ml-3 flex-1">Guest Post Department</span>
                <span class="transform transition-transform duration-300" :class="open ? 'rotate-180' : ''">▼</span>
            </button>
            <div x-show="open" @click.away="open = false"
                x-transition:enter="transition ease-out duration-300 transform opacity-0 scale-95"
                x-transition:enter-end="opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-200 transform opacity-100 scale-100"
                x-transition:leave-end="opacity-0 scale-95"
                class="mt-2 bg-gray-800 rounded-lg shadow-lg overflow-hidden">
                <a href="<?php echo e(route('guest-posts.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">📝 Guest Post</a>
                <a href="<?php echo e(route('gigs.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">💼 Gigs</a>
                <a href="<?php echo e(route('link-building.index')); ?>" class="block py-3 px-5 transition duration-200 hover:bg-gray-700">🔗 Link Building</a>
            </div>
        </div>

        <!-- Support Tickets -->
        <a href="<?php echo e(route('support-tickets.index')); ?>"
            class="flex items-center py-3 px-4 rounded-lg transition-all duration-300 hover:bg-gradient-to-r from-blue-500 to-purple-500 hover:shadow-lg">
            🎫 <span class="ml-3">Support Tickets</span>
        </a>
    </nav>

    <!-- Logout -->
    <div class="mt-auto">
        <form method="POST" action="<?php echo e(route('logout')); ?>">
            <?php echo csrf_field(); ?>
            <button type="submit"
                class="flex items-center py-3 px-4 w-full text-left bg-red-600 rounded-lg transition-all duration-300 hover:bg-red-700 hover:shadow-lg">
                🔓 <span class="ml-3">Logout</span>
            </button>
        </form>
    </div>
</aside>
<?php /**PATH C:\xampp\htdocs\crm\resources\views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>