<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Project; // Adjust model name if needed
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class MyAssignedProjectController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $userId = $user->id;
    
        // Base query
        $projectsQuery = Project::query();
    
        // Employee logic
        if ($user->hasRole('Employee')) {
            $projectsQuery->where('assign_main_employee_id', $userId);
        }
    
        // Team Lead logic
        if ($user->hasRole('Team Lead')) {
            $projectsQuery->orWhere('team_lead_id', $userId);
        }
    
        // Sales Team logic
        if ($user->hasRole('Sales Team')) {
            $projectsQuery->orWhere('sales_person_id', $userId);
        }
    
        // Get project IDs for amount received calculation
        $assignedProjectIds = (clone $projectsQuery)->pluck('id');
    
        $totalProjects = (clone $projectsQuery)->count();
        $activeProjects = (clone $projectsQuery)->where('project_status', 'Working')->count();
        $predictionAmount = (clone $projectsQuery)->sum('price');
    
        $amountReceived = DB::table('project_payments')
            ->whereIn('project_id', $assignedProjectIds)
            ->sum('payment_amount');
    
        $projects = $projectsQuery
            ->with([
                'projectManager', 'salesPerson', 'department',
                'projectCategory', 'projectSubCategory', 'country', 'assignMainEmployee'
            ])
            ->orderBy('created_at', 'desc')
            ->paginate(10);
    
        return view('my-assigned-projects.index', compact(
            'projects',
            'totalProjects',
            'activeProjects',
            'predictionAmount',
            'amountReceived'
        ));
    }
    
    
}

