<?php

namespace App\Models;
use Spatie\Permission\Traits\HasRoles;
use App\Models\HrNote;


// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Models\Department;
use App\Models\UserNote;
use Carbon\Carbon;



class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable,HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
       'name', 'email', 'password', 'phone_number', 'monthly_target', 'upsell_incentive',
        'role', 'reporting_person', 'department_id', 'allow_view_all_projects',
        'disable_login', 'image', 'experience', 'qualification', 'specialization',
        'date_of_joining', 'employee_code','monthly_salary','allow_all_projects',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function department()
{
    return $this->belongsTo(Department::class, 'department_id');
}

public function reportingPerson()
{
    return $this->belongsTo(User::class, 'reporting_person');
}
public function projects()
{
    return $this->hasMany(Project::class,'assign_main_employee_id'); // Adjust this as per your database relationship
}
public function saleTeamProjects()
{
    return $this->hasMany(SaleTeamProject::class, 'sales_person_id');
}
public function user()
{
    return $this->belongsTo(User::class, 'user_id');
}
public function assignedProjects()
{
    return $this->belongsToMany(Project::class);
}
public function dsrs()
{
    return $this->hasMany(Dsr::class, 'user_id'); // or correct foreign key
}

public function tasks()
{
    return $this->belongsToMany(Task::class, 'task_user_days')
                ->withPivot('days')
                ->withTimestamps();
}
public function userNotes()
{
    return $this->hasMany(UserNote::class);
}
public function hrNotes()
{
    return $this->hasMany(HrNote::class);
}
// Accessor for calculated experience
public function getCompanyExperienceAttribute($value)
{
    if ($this->date_of_joining) {
        $start = \Carbon\Carbon::parse($this->date_of_joining);
        $now = \Carbon\Carbon::now();

        $diff = $start->diff($now);

        $years = $diff->y;
        $months = $diff->m;
        $days = $diff->d;

        if ($years > 0) {
            return "{$years} year(s) {$months} month(s)";
        } elseif ($months > 0) {
            return "{$months} month(s) {$days} day(s)";
        } else {
            return "{$days} day(s)";
        }
    }

    // fallback if no joining date
    return $value ?? 'N/A';
}


}
