@extends('layouts.dashboard')

@section('content')
<div class="max-w-3xl mx-auto bg-white shadow-md rounded-xl p-6 mt-8">
    <h2 class="text-2xl font-semibold text-gray-800 mb-4">Upload Attachments for: 
        <span class="text-blue-600">{{ $sales_project->name ?? 'Project' }}</span>
    </h2>

    @if ($errors->any())
        <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
            <ul class="list-disc pl-5 space-y-1">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (session('success'))
    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded" id="success-message">
        {{ session('success') }}
    </div>

    <script>
        // Redirect after 3 seconds (3000 milliseconds)
        setTimeout(function() {
            window.location.href = "{{ route('sales-projects.index') }}";
        }, 1000);
    </script>
@endif


    <form action="{{ route('sales-projects.attachments.store', $sales_project->id) }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 mb-1">Upload Attachments</label>
            <input 
                type="file" 
                name="attachments[]" 
                multiple 
                required 
                class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:border-blue-400"
            >
            <p class="text-xs text-gray-500 mt-1">You can upload multiple files. Max size per file: 10MB.</p>
        </div>

        <div class="flex justify-end">
            <a href="{{ route('sales-projects.index') }}" class="mr-4 inline-block px-4 py-2 border border-gray-300 rounded-md text-sm text-gray-700 hover:bg-gray-100">
                Cancel
            </a>
            <button 
                type="submit" 
                class="px-4 py-2 bg-blue-600 text-white rounded-md text-sm hover:bg-blue-700 transition">
                Upload
            </button>
        </div>
    </form>
</div>
@endsection
