

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <h2 class="text-2xl font-semibold mb-4">Team Report</h2>

    
    <form method="GET" action="<?php echo e(route('projectManager.teamReport')); ?>" class="mb-6">
        <div class="form-group flex gap-4 items-center">
            <label for="report_month" class="font-semibold">Select Month and Year:</label>

            <select name="report_month" class="form-control w-32">
                <option value="ALL" <?php echo e($selectedMonth == 'ALL' ? 'selected' : ''); ?>>ALL</option>
                <?php $__currentLoopData = range(1,12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e(str_pad($month, 2, '0', STR_PAD_LEFT)); ?>"
                        <?php echo e($selectedMonth == str_pad($month, 2, '0', STR_PAD_LEFT) ? 'selected' : ''); ?>>
                        <?php echo e(\Carbon\Carbon::create()->month($month)->format('F')); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <select name="report_year" class="form-control w-32">
                <?php $__currentLoopData = range(2019, now()->year + 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($year); ?>" <?php echo e($selectedYear == $year ? 'selected' : ''); ?>><?php echo e($year); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <button type="submit" class="btn btn-primary px-4 py-2 rounded bg-blue-600 text-white">Filter</button>
        </div>
    </form>

    
    <div class="grid grid-cols-2 md:grid-cols-3 gap-4 mb-6">
        <div class="bg-gray-800 text-white p-4 rounded shadow">Total Employees: <?php echo e($stats['totalEmployees']); ?></div>
        <div class="bg-gray-800 text-white p-4 rounded shadow">Total Assigned Hours: <?php echo e($stats['totalAssignedHours']); ?></div>
        <div class="bg-gray-800 text-white p-4 rounded shadow">Total Worked Hours: <?php echo e($stats['totalWorkedHours']); ?></div>
        <div class="bg-gray-800 text-white p-4 rounded shadow">Total Payment:$ <?php echo e(number_format($stats['totalPayment'], 2)); ?></div>
        <div class="bg-gray-800 text-white p-4 rounded shadow">Total Received:$ <?php echo e(number_format($stats['totalReceived'], 2)); ?></div>
        <div class="bg-gray-800 text-white p-4 rounded shadow">Total Upsell Amount: <?php echo e(number_format($stats['totalUpsellAmount'], 2)); ?></div>
    </div>

    <h3 class="text-xl font-semibold mb-3">Team Members</h3>

    <?php
        $currentUser = auth()->user();
    ?>

    <div class="bg-white shadow rounded p-4">
        <table class="min-w-full table-auto border">
            <thead>
                <tr class="bg-gray-200 text-left">
                    <th class="p-2 border">#</th>
                    <th class="p-2 border">Name</th>
                    <th class="p-2 border">Experience</th>
                    <th class="p-2 border">Assigned Hours</th>
                    <th class="p-2 border">Worked Hours</th>
                    <th class="p-2 border">Total Payment</th>
                    <th class="p-2 border">Received Payment</th>
                    <th class="p-2 border">Upsell Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $membersData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $isProjectManager = $member['user']->id === $currentUser->id;
                    ?>
                    <tr class="border-b <?php echo e($isProjectManager ? 'bg-blue-50 font-semibold' : ''); ?>">
                        <td class="p-2 border"><?php echo e($index + 1); ?></td>
                        <td class="p-2 border">
                            <?php echo e($member['user']->name); ?>

                            <?php if($isProjectManager): ?>
                                <span class="text-sm text-blue-600 font-bold">(PM)</span>
                            <?php endif; ?>
                        </td>
                        <td class="p-2 border"><?php echo e($member['user']->experience ?? '-'); ?></td>
                        <td class="p-2 border"><?php echo e($member['assignedHours']); ?></td>
                        <td class="p-2 border"><?php echo e($member['workedHours']); ?></td>
                        <td class="p-2 border">$<?php echo e(number_format($member['payment'] ?? 0, 2)); ?></td>
                        <td class="p-2 border">$<?php echo e(number_format($member['received'] ?? 0, 2)); ?></td>
                        <td class="p-2 border">
                            <?php if($isProjectManager): ?>
                                <?php echo e(number_format($member['upsell'], 2)); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr class="bg-gray-100 font-semibold">
                    <td class="p-2 border" colspan="3">Total Employees: <?php echo e($stats['totalEmployees']); ?></td>
                    <td class="p-2 border"><?php echo e($stats['totalAssignedHours']); ?></td>
                    <td class="p-2 border"><?php echo e($stats['totalWorkedHours']); ?></td>
                    <td class="p-2 border">$<?php echo e(number_format($stats['totalPayment'], 2)); ?></td>
                    <td class="p-2 border">$<?php echo e(number_format($stats['totalReceived'], 2)); ?></td>
                    <td class="p-2 border"><?php echo e(number_format($stats['totalUpsellAmount'], 2)); ?></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravelcrm/crm/resources/views/dashboard/project_manager_team_report.blade.php ENDPATH**/ ?>