

<?php $__env->startSection('content'); ?>
<div class="container mx-auto py-10">
    <h2 class="text-3xl font-bold mb-8 text-gray-800">Single Employee DSR Report</h2>

    <form method="POST" action="<?php echo e(route('employee.all.dsr.search')); ?>" class="mb-8 bg-white p-6 rounded shadow">
    <?php echo csrf_field(); ?>
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div>
            <label class="block mb-1 font-semibold text-gray-700">Select Employee</label>
            <select name="user_id" class="w-full border-gray-300 rounded shadow-sm">
                <option value="">-- Select --</option>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($u->id); ?>" <?php echo e(old('user_id', $user->id ?? '') == $u->id ? 'selected' : ''); ?>>
                        <?php echo e($u->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div>
            <label class="block mb-1 font-semibold text-gray-700">Month</label>
            <select name="month" class="w-full border-gray-300 rounded shadow-sm">
                <?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($m); ?>" <?php echo e(old('month', $month) == $m ? 'selected' : ''); ?>>
                        <?php echo e(DateTime::createFromFormat('!m', $m)->format('F')); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div>
            <label class="block mb-1 font-semibold text-gray-700">Year</label>
            <select name="year" class="w-full border-gray-300 rounded shadow-sm">
                <?php for($y = date('Y'); $y >= 2020; $y--): ?>
                    <option value="<?php echo e($y); ?>" <?php echo e(old('year', $year) == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                <?php endfor; ?>
            </select>
        </div>

        <div class="flex items-end">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-2 rounded shadow">
                View Report
            </button>
        </div>
    </div>
</form>

    <?php if(isset($dsrReports)): ?>
    <div class="bg-white p-6 rounded shadow">
        <h3 class="text-xl font-semibold mb-4 text-gray-800">
            <?php echo e($user->name); ?> - <?php echo e(DateTime::createFromFormat('!m', $month)->format('F')); ?> <?php echo e($year); ?> Summary
        </h3>

        <?php
            $totalAssignedHours = 0;
            $totalWorkedHours = 0;
            $groupedProjects = $dsrDetails->groupBy('project_id');
        ?>

        <!-- Summary Table -->
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white border border-gray-300 rounded shadow mb-8">
                <thead class="bg-gray-100 text-gray-700">
                    <tr>
                        <th class="py-3 px-4 text-left">SR No.</th>
                        <th class="py-3 px-4 text-left">Project Name</th>
                        <th class="py-3 px-4 text-left">Assigned Hours</th>
                        <th class="py-3 px-4 text-left">Worked Hours</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $groupedProjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectId => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $project = \App\Models\Project::find($projectId);
                            $assigned = $project->estimated_hours ?? 0;
                            $worked = $group->sum('hours');
                            $totalAssignedHours += $assigned;
                            $totalWorkedHours += $worked;
                        ?>
                        <tr class="hover:bg-gray-50 border-t">
                            <td class="py-2 px-4"><?php echo e($loop->iteration); ?></td>
                            <td class="py-2 px-4"><?php echo e($project->name_or_url ?? 'N/A'); ?></td>
                            <td class="py-2 px-4"><?php echo e($assigned); ?></td>
                            <td class="py-2 px-4"><?php echo e($worked); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <!-- Totals Row -->
                    <tr class="bg-gray-200 text-gray-800 font-semibold text-sm border-t">
                        <td colspan="4" class="py-3 px-4 text-center">
                            Total Projects: <?php echo e($groupedProjects->count()); ?> &nbsp;&nbsp;|&nbsp;&nbsp;
                            Assigned Hours: <?php echo e($totalAssignedHours); ?> &nbsp;&nbsp;|&nbsp;&nbsp;
                            Worked Hours: <?php echo e($totalWorkedHours); ?>

                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Daily Work Table -->
        <h4 class="text-lg font-semibold mb-4 text-gray-800">Daily Work Details</h4>
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white border border-gray-300 rounded shadow">
                <thead class="bg-gray-100 text-gray-700">
                    <tr>
                        <th class="py-3 px-4 text-left">SR No.</th>
                        <th class="py-3 px-4 text-left">Project Name</th>
                        <th class="py-3 px-4 text-left">Work Details</th>
                        <th class="py-3 px-4 text-left">Date</th>
                        <th class="py-3 px-4 text-left">Hours</th>
                        <th class="py-3 px-4 text-left">Someone Helped</th>
                        <th class="py-3 px-4 text-left">Manager Comments</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $dsrDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50 border-t">
                            <td class="py-2 px-4"><?php echo e($loop->iteration); ?></td>
                            <td class="py-2 px-4"><?php echo e($detail->project->name_or_url ?? 'N/A'); ?></td>
                            <td class="py-2 px-4 text-sm text-gray-700"><?php echo e(Str::words($detail->work_description, 50, '...')); ?></td>
                            <td class="py-2 px-4"><?php echo e($detail->date); ?></td>
                            <td class="py-2 px-4"><?php echo e($detail->hours); ?></td>
                            <td class="py-2 px-4"><?php echo e($detail->someone_helped); ?></td>
                            <td class="py-2 px-4 text-sm text-gray-600"><?php echo e($detail->manager_comments); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravelcrm/crm/resources/views/dsr/employee_all_dsr.blade.php ENDPATH**/ ?>