

<?php $__env->startSection('content'); ?>
<div class="container grid grid-cols-1 md:grid-cols-2 gap-6">

    <!-- Section 1: Sales Lead Details -->
    <div class="bg-white rounded-xl shadow-lg p-6">
        <h2 class="text-xl font-bold mb-4">Sales Lead Details</h2>
        <ul class="text-sm space-y-2">
            <li><strong>Bid Date:</strong> <?php echo e(optional($lead->bid_date)->format('d-F-Y')); ?></li>
            <li><strong>Status:</strong> <?php echo e($lead->status ?? '-'); ?></li>
            <li><strong>Status Message:</strong> <?php echo e($lead->status_message ?? '-'); ?></li>
            <li><strong>Status Updated:</strong> <?php echo e(optional($lead->updated_at)->format('d-F-Y')); ?></li>
            <li><strong>Client Name:</strong> <?php echo e($lead->client_name); ?></li>
            <li><strong>Email:</strong> <?php echo e($lead->client_email); ?></li>
            <li><strong>Phone:</strong> <?php echo e($lead->client_phone); ?></li>
            <li><strong>Client Type:</strong> <?php echo e($lead->client_type); ?></li>
            <li><strong>Job Title:</strong> <?php echo e($lead->job_title); ?></li>
            <li><strong>Job URL:</strong> <a href="<?php echo e($lead->job_url); ?>" class="text-blue-600 underline" target="_blank"><?php echo e($lead->job_url); ?></a></li>
            <li><strong>Country:</strong> <?php echo e($lead->country->name ?? '-'); ?></li>
            <li><strong>Lead From:</strong> <?php echo e($lead->lead_from); ?></li>
            <li><strong>Sales Person:</strong> <?php echo e($lead->user->name ?? '-'); ?></li>
            <li><strong>Department:</strong> <?php echo e($lead->department->name ?? '-'); ?></li>
        </ul>
    </div>

    <!-- Section 2: General Notes -->
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-bold">General Notes</h2>
            <button onclick="document.getElementById('noteModal').classList.remove('hidden')" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                Add Note
            </button>
        </div>

        <div class="space-y-3 max-h-96 overflow-y-auto">
            <?php $__empty_1 = true; $__currentLoopData = $lead->notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="border p-3 rounded shadow-sm">
                    <div class="flex justify-between items-center text-sm text-gray-600">
                        <span><strong><?php echo e($note->note_type); ?></strong> - <?php echo e($note->title); ?></span>
                        <span><?php echo e($note->created_at->diffForHumans()); ?></span>
                    </div>
                    <p class="mt-1 text-sm"><?php echo e($note->description); ?></p>
                    <?php if($note->attachment): ?>
                        <a href="<?php echo e(asset('storage/' . $note->attachment)); ?>" target="_blank" class="text-blue-600 text-sm">View Attachment</a>
                    <?php endif; ?>
                    <div class="text-xs text-gray-400 mt-1">Added by: <?php echo e($note->user->name ?? 'N/A'); ?></div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-gray-500 text-sm">No notes added yet.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal: Add Note -->
<div id="noteModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
    <div class="bg-white rounded-lg w-full max-w-md p-6 relative">
        <button onclick="document.getElementById('noteModal').classList.add('hidden')" class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-xl font-bold">&times;</button>
        <h3 class="text-lg font-bold mb-4">Add Note</h3>
        <form method="POST" action="<?php echo e(route('sales-lead.addNote', $lead->id)); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
                <label class="block text-sm font-medium">Note Type</label>
                <select name="note_type" class="w-full border rounded p-2">
                    <option value="Follow up">Follow up</option>
                    <option value="General">General</option>
                </select>
            </div>
            <div class="mb-3">
                <label class="block text-sm font-medium">Title</label>
                <input type="text" name="title" class="w-full border rounded p-2" required>
            </div>
            <div class="mb-3">
                <label class="block text-sm font-medium">Description</label>
                <textarea name="description" class="w-full border rounded p-2" required></textarea>
            </div>
            <div class="mb-3">
                <label class="block text-sm font-medium">Attachment (optional)</label>
                <input type="file" name="attachment" class="w-full">
            </div>
            <div class="text-right">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Save Note</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravelcrm/crm/resources/views/sales_leads/show.blade.php ENDPATH**/ ?>