

<?php $__env->startSection('title', 'All Submitted Task Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white shadow p-6 rounded mb-6">
    <form method="GET" action="<?php echo e(route('submitted.tasks')); ?>" class="flex items-center gap-4">

    <div>
            <label class="text-sm font-medium text-gray-700"></label>
            <select name="filter_created_by" class="border rounded px-3 py-2 text-sm">
                <option value="" selected>Show All</option>
            </select>
        </div>
        <div>
            <label class="text-sm font-medium text-gray-700">Select Employee</label>
            <select name="filter_user" class="border rounded px-3 py-2 text-sm">
                <option value="">-- All Users --</option>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>" <?php echo e($filterUser == $user->id ? 'selected' : ''); ?>>
                        <?php echo e($user->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
       
        <div class="pt-6">
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded shadow hover:bg-blue-700">Filter</button>
        </div>
    </form>
</div>

<div class="bg-white shadow-md rounded-lg p-6">
    <h2 class="text-2xl font-semibold mb-4">Submitted Task Messages</h2>
    <div class="overflow-x-auto">
        <table class="w-full border-collapse bg-white shadow rounded text-left">
            <thead class="bg-gray-200 text-gray-700 font-semibold">
                <tr>
                    <th class="border px-4 py-2">S/N</th>
                    <th class="border px-4 py-2">Task Name</th>
                    <th class="border px-4 py-2">Username</th>

                    <th class="border px-4 py-2">Message</th>
                    <th class="border px-4 py-2">Assigned By</th>
                    <th class="border px-4 py-2">Submitted At</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $submittedTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-100">
                        <td class="border px-4 py-2"><?php echo e($submittedTasks->firstItem() + $loop->index); ?></td>
                        <td class="border px-4 py-2"><?php echo e($task->name); ?></td>
                        <td class="border px-4 py-2">
                            <?php $__currentLoopData = $task->assignedUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div><?php echo e($user->name); ?></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="border px-4 py-2"><?php echo e($task->done_message); ?></td>
                      
                        <td class="border px-4 py-2"><?php echo e($task->createdBy->name ?? '-'); ?></td>
                        <td class="border px-4 py-2"><?php echo e($task->updated_at->format('d M, Y')); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center py-4">No submitted messages found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="mt-4">
        <?php echo e($submittedTasks->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravelcrm/crm/resources/views/submitted_tasks/index.blade.php ENDPATH**/ ?>