<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', 'Website Submission'); ?></title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-gray-100">

    <!-- Navbar -->
    <nav class="bg-white shadow p-4">
        <div class="container mx-auto flex justify-between">
            <a href="<?php echo e(url('/')); ?>" class="font-bold text-xl text-gray-800">MySite</a>
            <div>
                <?php if(auth()->guard()->guest()): ?>
                    <a href="<?php echo e(route('login')); ?>" class="px-3">Login</a>
                    <a href="<?php echo e(route('register')); ?>" class="px-3">Register</a>
                <?php endif; ?>
                <?php if(auth()->guard()->check()): ?>
                    <span class="px-3">Hi, <?php echo e(auth()->user()->name); ?></span>
                    <a href="<?php echo e(route('dashboard')); ?>" class="px-3">Dashboard</a>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="container mx-auto py-6">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white p-4 text-center mt-6">
        &copy; <?php echo e(date('Y')); ?> MySite. All rights reserved.
    </footer>

</body>
</html>
<?php /**PATH /var/www/html/laravelcrm/crm/resources/views/layouts/frontend.blade.php ENDPATH**/ ?>