

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-10">
    <div class="bg-white p-8 rounded-2xl shadow-xl max-w-6xl mx-auto">
        <h2 class="text-2xl font-bold mb-6 text-gray-800 border-b pb-4">📧 Send Email to All Employees</h2>

        <form action="<?php echo e(route('admin.send.email.submit')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            
            <?php if(session('success')): ?>
                <div class="mb-4 p-4 bg-green-100 text-green-800 rounded shadow"><?php echo e(session('success')); ?></div>
            <?php elseif(session('error')): ?>
                <div class="mb-4 p-4 bg-red-100 text-red-800 rounded shadow"><?php echo e(session('error')); ?></div>
            <?php endif; ?>

            
            <div class="mb-6">
                <label for="email_subject" class="block text-lg font-medium text-gray-700 mb-2">Email Subject *</label>
                <input type="text" name="email_subject" id="email_subject"
                    class="w-full border border-gray-300 px-4 py-3 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-400"
                    placeholder="Enter email subject">
            </div>

            
            <div class="mb-6">
                <label for="email_content" class="block text-lg font-medium text-gray-700 mb-2">Email Content *</label>
                <textarea name="email_content" id="email_content" rows="10"
                    class="w-full border border-gray-300 px-4 py-3 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-400"
                    placeholder="Write your email message here..."></textarea>
            </div>

            
            <div class="text-right">
                <button type="submit"
                    class="bg-blue-600 hover:bg-blue-700 text-white font-semibold text-lg py-3 px-6 rounded-xl transition-all duration-200 shadow-md">
                    🚀 Send To All Employees
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravelcrm/crm/resources/views/notifications/send-email.blade.php ENDPATH**/ ?>