

<?php $__env->startSection('content'); ?>
<div class="p-4 bg-white shadow rounded-lg">
    <h2 class="text-xl font-bold mb-4">Projects Audit</h2>

    <!-- 🔹 Filter Form -->
    <form method="GET" action="<?php echo e(route('projects.audit')); ?>" class="flex flex-wrap gap-4 mb-4">
        <!-- Hired From Filter -->
        <div>
            <!-- <label class="block text-sm font-semibold mb-1">Hired From</label>
            <select name="hired_from_id" class="border border-gray-300 rounded-lg px-3 py-2">
                <option value="">-- Select --</option>
                <?php $__currentLoopData = $hiredFroms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($hf->id); ?>" <?php echo e(request('hired_from_id') == $hf->id ? 'selected' : ''); ?>>
                        <?php echo e($hf->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select> -->
        </div>
  <!-- Project Manager Filter (Admin Only) -->
  <?php if(auth()->user()->hasRole('Admin')): ?>
        <div>
            <label class="block text-sm font-semibold mb-1">Filter By Project Manager</label>
            <select name="project_manager_id" class="border border-gray-300 rounded-lg px-3 py-2">
                <option value="">-- All Project Managers --</option>
                <?php $__currentLoopData = $projectManagers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($pm->id); ?>" <?php echo e(request('project_manager_id') == $pm->id ? 'selected' : ''); ?>>
                        <?php echo e($pm->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php endif; ?>
        <!-- Duration Filter -->
        <div>
            <label class="block text-sm font-semibold mb-1">Project Duration</label>
            <select name="duration" class="border border-gray-300 rounded-lg px-3 py-2">
                <option value="">-- Select --</option>
                <?php $__currentLoopData = [2,4,6,8,10]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($month); ?>" <?php echo e(($duration ?? 2) == $month ? 'selected' : ''); ?>>
                        <?php echo e($month); ?> Months
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

      

        <div class="flex items-end">
            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg shadow hover:bg-blue-700">
                Filter
            </button>
        </div>
    </form>

    <hr class="my-4">

    <!-- 🔹 Projects Listing -->
    <div class="overflow-x-auto">
        <table class="w-full border-collapse border border-gray-300 text-sm">
            <thead>
                <tr class="bg-gray-100">
                    <th class="border px-3 py-2">#</th>
                    <th class="border px-3 py-2">Name/URL</th>
                    <th class="border px-3 py-2">Office Details</th>
                    <th class="border px-3 py-2">Price/Hours</th>
                    <th class="border px-3 py-2">Added On</th>
                    <th class="border px-3 py-2">Type</th>
                    <th class="border px-3 py-2">Status</th>

                    <th class="border px-3 py-2">Client Details</th>
                    <th class="border px-3 py-2">Description</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $paginatedProjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $receivedAmount = $project->projectPayments->sum('payment_amount');

                    $statusColors = [
                        'complete'   => 'text-green-600 font-bold',
                        'working'    => 'text-green-600 font-bold',
                        'hold'       => 'text-yellow-600 font-bold',
                        'paused'     => 'text-purple-600 font-bold',
                        'issues'     => 'text-red-600 font-bold',
                        'temp hold'  => 'text-orange-600 font-bold',
                        'closed'     => 'text-gray-600 font-bold',
                    ];
                    $statusRaw = $project->project_status ?? 'working';
                    $status = strtolower(trim($statusRaw));
                    $statusClass = $statusColors[$status] ?? 'text-gray-500 font-bold';
                ?>
                <tr>
                    <td class="border px-3 py-2">SEODIS-<?php echo e($paginatedProjects->firstItem() + $key); ?></td>
                    <td class="border px-3 py-2">
                        <strong><?php echo e($project->name_or_url); ?></strong><br>
                        <?php if($project->dashboard_url): ?>
                        <a href="<?php echo e($project->dashboard_url); ?>" target="_blank" class="text-blue-500 underline">Dashboard Link</a>
                        <?php endif; ?>
                    </td>
                    <td class="border px-3 py-2">
                        <div><strong>Grade:</strong> <?php echo e($project->project_grade ?? 'NA'); ?></div>
                        <div><strong>PM:</strong> <?php echo e(optional($project->projectManager)->name ?? 'NA'); ?></div>
                        <div><strong>Sales:</strong> <?php echo e(optional($project->salesPerson)->name ?? 'NA'); ?></div>
                        <div><strong>Employee:</strong> <?php echo e(optional($project->assignMainEmployee)->name ?? 'NA'); ?></div>
                        <div><strong>Department:</strong> <?php echo e(optional($project->department)->name ?? 'NA'); ?></div>
                    </td>
                    <td class="border px-3 py-2">
                        <div class="mb-2"><strong>Price:</strong> $<?php echo e(number_format($project->display_price ?? 0, 2)); ?></div>
                        <div class="mb-2"><strong>Hours:</strong> <?php echo e($project->display_hours ?? '0'); ?></div>
                        <div class="mb-2">
                            <a target="_blank" href="<?php echo e(route('project_payments.index', ['project_id' => $project->id])); ?>">
                                <span class="px-3 py-1 text-white rounded-lg shadow-md
                                    bg-gradient-to-r from-blue-400 via-blue-500 to-blue-600
                                    hover:from-blue-500 hover:via-blue-600 hover:to-blue-700
                                    inline-flex items-center gap-2">
                                    Received Price: <?php echo e($receivedAmount); ?>

                                </span>
                            </a>
                        </div>
                        <div>
                            <?php
                                $duration = $project->created_at ? $project->created_at->diff(now()) : null;
                            ?>

                            <?php if($duration): ?>
                                <span class="px-3 py-1 text-white rounded-lg shadow-md
                                    bg-gradient-to-r from-blue-400 via-blue-500 to-blue-600
                                    hover:from-blue-500 hover:via-blue-600 hover:to-blue-700
                                    inline-flex items-center gap-2">
                                    Project Duration:
                                    <?php
                                        $parts = [];
                                        if ($duration->y > 0) $parts[] = $duration->y . ' year(s)';
                                        if ($duration->m > 0) $parts[] = $duration->m . ' month(s)';
                                        $parts[] = $duration->d . ' day(s)'; // ✅ shows 0 if today
                                    ?>
                                    <?php echo e(implode(' ', $parts)); ?>

                                </span>
                            <?php else: ?>
                                <span class="text-gray-400">Project Duration: N/A</span>
                            <?php endif; ?>
                        </div>
                    </td>
                    <td class="border px-3 py-2"><?php echo e($project->created_at->format('d-M-Y')); ?></td>
                    <td class="border px-3 py-2"><?php echo e($project->project_type ?? '-'); ?></td>
                    <td class="border px-3 py-2">
                        <span class="<?php echo e($statusClass); ?>"><?php echo e(ucfirst($statusRaw)); ?></span>
                    </td>
                    <td class="border px-3 py-2">
                <div><strong>Client Name:</strong> <?php echo e($project->client_name ?? 'NA'); ?></div>
               <div><strong>Client Email:</strong> <?php echo e($project->client_email ?? 'NA'); ?></div>
              <div><strong>Other Info:</strong> <?php echo e($project->client_other_info ?? 'NA'); ?></div>
</td>

                 
                    <td class="border px-3 py-2"><?php echo e(Str::limit($project->display_description, 50)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="9" class="text-center py-4 text-gray-500">No projects found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        <?php echo e($paginatedProjects->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravelcrm/crm/resources/views/projects/audit.blade.php ENDPATH**/ ?>