

<?php $__env->startSection('title', 'Team Reviews'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <h1 class="text-2xl font-bold mb-4">Team Reviews — Month: <?php echo e(\Carbon\Carbon::parse($month)->format('F Y')); ?></h1>

    <form method="GET" class="mb-4">
        <label for="month">Select month:</label>
        <input type="month" id="month" name="month" value="<?php echo e($month); ?>" onchange="this.form.submit()" class="border p-1 rounded"/>
    </form>

    <?php if(session('success')): ?>
        <div class="bg-green-100 text-green-800 p-3 rounded mb-4"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="overflow-x-auto">
        <table class="w-full border rounded-lg shadow-sm">
            <thead>
                <tr class="bg-gray-800 text-white">
                    <th class="p-2">Employee</th>
                    <th class="p-2">Email</th>
                    <th class="p-2">Quality of Work</th>
                    <th class="p-2">Communication</th>
                    <th class="p-2">Ownership</th>
                    <th class="p-2">Team Collaboration</th>
                    <th class="p-2">Overall Rating</th>
                    <th class="p-2">Comments</th>
                    <th class="p-2">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $team; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php $r = $reviews[$emp->id] ?? null; ?>
                    <tr class="border-b">
                        <td class="p-2 font-medium"><?php echo e($emp->name); ?></td>
                        <td class="p-2 text-sm text-gray-600"><?php echo e($emp->email); ?></td>
                        <td class="p-2 text-center"><?php echo e($r->quality_of_work ?? '-'); ?></td>
                        <td class="p-2 text-center"><?php echo e($r->communication ?? '-'); ?></td>
                        <td class="p-2 text-center"><?php echo e($r->ownership ?? '-'); ?></td>
                        <td class="p-2 text-center"><?php echo e($r->team_collaboration ?? '-'); ?></td>
                        <td class="p-2 text-center font-semibold text-blue-600"><?php echo e($r->overall_rating ?? '-'); ?></td>
                        <td class="p-2"><?php echo e($r->comments ?? '-'); ?></td>
                        <td class="p-2">
                            <button 
                                class="bg-indigo-600 text-white px-3 py-1 rounded text-sm edit-btn" 
                                onclick="document.getElementById('form-<?php echo e($emp->id); ?>').classList.toggle('hidden')">
                                <?php echo e($r ? 'Edit' : 'Add'); ?>

                            </button>
                        </td>
                    </tr>

                    <!-- Hidden edit/add form -->
                    <tr id="form-<?php echo e($emp->id); ?>" class="hidden bg-gray-50">
                        <td colspan="9" class="p-4">
                            <form method="POST" action="<?php echo e(route('pm.reviews.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="employee_id" value="<?php echo e($emp->id); ?>">
                                <input type="hidden" name="review_month" value="<?php echo e($month); ?>">

                                <div class="grid grid-cols-4 gap-3 mb-3">
                                    <?php
                                        $q = $r->quality_of_work ?? '';
                                        $c = $r->communication ?? '';
                                        $o = $r->ownership ?? '';
                                        $t = $r->team_collaboration ?? '';
                                    ?>

                                    <div>
                                        <label class="block text-sm font-medium">Quality of Work</label>
                                        <select name="quality_of_work" required class="w-full border p-1 rounded">
                                            <?php for($i=1;$i<=10;$i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php echo e($q == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium">Communication</label>
                                        <select name="communication" required class="w-full border p-1 rounded">
                                            <?php for($i=1;$i<=10;$i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php echo e($c == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium">Ownership</label>
                                        <select name="ownership" required class="w-full border p-1 rounded">
                                            <?php for($i=1;$i<=10;$i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php echo e($o == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium">Team Collaboration</label>
                                        <select name="team_collaboration" required class="w-full border p-1 rounded">
                                            <?php for($i=1;$i<=10;$i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php echo e($t == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="block text-sm font-medium">Comments (optional)</label>
                                    <textarea name="comments" rows="2" class="w-full border p-1 rounded"><?php echo e($r->comments ?? ''); ?></textarea>
                                </div>

                                <div>
                                    <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded">
                                        Save Review
                                    </button>
                                </div>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center py-4 text-gray-500">No active employees found in your team.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravelcrm/crm/resources/views/reviews/index.blade.php ENDPATH**/ ?>