

<?php $__env->startSection('content'); ?>
<div class="container mx-auto py-10">
    <h2 class="text-3xl font-bold mb-6">
        DSR Report - <?php echo e($dsr->user->name); ?> (<?php echo e($dsr->created_at->format('Y-m-d')); ?>)
    </h2>

    <?php $__currentLoopData = $dsrReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white border border-gray-300 rounded-lg shadow-md mb-6 p-6">
            <h3 class="text-xl font-semibold mb-2">
                Project Name:
                <?php echo e($report->project->name_or_url ?? 'N/A'); ?>

            </h3>

            <p><strong>Hours:</strong> <?php echo e($report->hours); ?></p>

            <div class="mb-3">
                <strong>Work Details:</strong>
                <p class="whitespace-pre-line"><?php echo e($report->work_description); ?></p>
            </div>

            <?php if($report->links): ?>
                <div class="mb-3">
                    <strong>Related Links:</strong>
                    <div class="text-blue-600">
                        <?php echo nl2br(e($report->links)); ?>

                    </div>
                </div>
            <?php endif; ?>

            <?php if($report->helped_by || $report->help_description): ?>
                <div class="mb-3">
                    <strong>Helped By:</strong>
                    <?php echo e(optional($report->helper)->name ?? 'N/A'); ?>

                </div>
                <div class="mb-3">
                    <strong>Help Description:</strong>
                    <p class="whitespace-pre-line"><?php echo e($report->help_description); ?></p>
                </div>
            <?php endif; ?>

            <?php if($report->help_rating): ?>
                <p><strong>Rating for the work:</strong> <?php echo e($report->help_rating); ?></p>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="mt-6">
        <a href="<?php echo e(url()->previous()); ?>" class="text-blue-600 hover:underline">← Back</a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/laravelcrm/crm/resources/views/dsr/details.blade.php ENDPATH**/ ?>